/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.rest.RestAuthcConfig;
import com.floragunn.searchguard.authc.rest.authenticators.BasicAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.ActivatedFrontendConfig;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.FrontendAuthcConfig;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.injection.guice.Inject;

public class GetActivatedFrontendConfigAction
extends Action<Request, Response> {
    public static final GetActivatedFrontendConfigAction INSTANCE = new GetActivatedFrontendConfigAction();
    public static final String NAME = "cluster:admin:searchguard:auth/frontend/config/get";
    public static final RestApi REST_API = new RestApi().handlesGet("/_searchguard/auth/config").with((Action)INSTANCE, (params, body) -> new Request((String)params.get("config_id"), (String)params.get("next_url"), (String)params.get("frontend_base_url"))).handlesPost("/_searchguard/auth/config").with((Action)INSTANCE).name("Search Guard Frontend Auth Config");
    protected static final Logger log = LogManager.getLogger(GetActivatedFrontendConfigAction.class);

    protected GetActivatedFrontendConfigAction() {
        super(NAME, Request::new, Response::new);
    }

    public static class Request
    extends Action.Request {
        private final String nextURL;
        private final String configId;
        private final String frontendBaseUrl;

        public Request(String configId, String nextURL, String frontendBaseUrl) {
            this.configId = configId;
            this.nextURL = nextURL;
            this.frontendBaseUrl = frontendBaseUrl;
        }

        public Request(Action.UnparsedMessage message) throws ConfigValidationException {
            DocNode docNode = message.requiredDocNode();
            this.configId = docNode.getAsString("config_id");
            this.nextURL = docNode.getAsString("next_url");
            this.frontendBaseUrl = docNode.getAsString("frontend_base_url");
        }

        public Object toBasicObject() {
            return ImmutableMap.of((Object)"config_id", (Object)this.configId, (Object)"next_url", (Object)this.nextURL, (Object)"frontend_base_url", (Object)this.frontendBaseUrl);
        }

        public String getNextURL() {
            return this.nextURL;
        }

        public String getConfigId() {
            return this.configId;
        }

        public String getFrontendBaseUrl() {
            return this.frontendBaseUrl;
        }
    }

    public static class Handler
    extends Action.Handler<Request, Response> {
        private ConfigurationRepository configRepository;

        @Inject
        public Handler(Action.HandlerDependencies handlerDependencies, ConfigurationRepository configRepository) {
            super((Action)INSTANCE, handlerDependencies);
            this.configRepository = configRepository;
        }

        protected CompletableFuture<Response> doExecute(Request request) {
            String configId = request.getConfigId() != null ? request.getConfigId() : "default";
            FrontendAuthcConfig frontendConfig = this.configRepository.getConfiguration(CType.FRONTEND_AUTHC).getCEntry(configId);
            if (frontendConfig == null && this.configRepository.getConfiguration(CType.FRONTEND_AUTHC).getCEntries().isEmpty()) {
                frontendConfig = this.getFallbackFrontendConfig();
            }
            if (frontendConfig == null) {
                throw Handler.notFound((String)("No such frontend config: " + configId));
            }
            ImmutableList<FrontendAuthcConfig.FrontendAuthenticationDomain> authMethods = frontendConfig.getAuthDomains();
            ArrayList<ActivatedFrontendConfig.AuthMethod> result = new ArrayList<ActivatedFrontendConfig.AuthMethod>(authMethods.size());
            for (FrontendAuthcConfig.FrontendAuthenticationDomain authMethod : authMethods) {
                if (!authMethod.isEnabled()) continue;
                String type = authMethod.getAuthenticationFrontend() != null ? authMethod.getAuthenticationFrontend().getType() : authMethod.getType();
                ActivatedFrontendConfig.AuthMethod activatedAuthMethod = new ActivatedFrontendConfig.AuthMethod(type, authMethod.getLabel(), authMethod.getId(), true, authMethod.isUnavailable(), authMethod.isCaptureUrlFragment(), authMethod.isAutoSelect(), null, authMethod.getMessage());
                if (authMethod.getAuthenticationFrontend() instanceof ApiAuthenticationFrontend) {
                    try {
                        activatedAuthMethod = ((ApiAuthenticationFrontend)authMethod.getAuthenticationFrontend()).activateFrontendConfig(activatedAuthMethod, request);
                    }
                    catch (AuthenticatorUnavailableException e) {
                        log.error("Error while activating " + authMethod + "\n" + e.getDetails(), (Throwable)e);
                        String messageTitle = "Temporarily Unavailable";
                        String messageBody = "Please try again later or contact your administrator.";
                        com.floragunn.fluent.collections.ImmutableMap<String, Object> details = null;
                        if (frontendConfig.isDebug()) {
                            messageTitle = e.getMessageTitle();
                            messageBody = e.getMessageBody();
                            details = e.getDetails();
                        }
                        activatedAuthMethod = activatedAuthMethod.unavailable(messageTitle, messageBody, (Map<String, Object>)details);
                    }
                    catch (Exception e) {
                        log.error("Error while activating " + authMethod, (Throwable)e);
                        ImmutableMap details = null;
                        Object messageTitle = "Temporarily Unavailable";
                        String messageBody = "Please try again later or contact your administrator.";
                        if (frontendConfig.isDebug()) {
                            messageTitle = "Unexpected error while " + type + " login";
                            messageBody = e.toString();
                            StringWriter stringWriter = new StringWriter();
                            e.printStackTrace(new PrintWriter(stringWriter));
                            details = ImmutableMap.of((Object)"exception", (Object)ImmutableList.ofArray((Object[])stringWriter.toString().split("\n")));
                        }
                        activatedAuthMethod = activatedAuthMethod.unavailable((String)messageTitle, messageBody, (Map<String, Object>)details);
                    }
                }
                result.add(activatedAuthMethod);
            }
            return CompletableFuture.completedFuture(new Response(result, frontendConfig.getLoginPage()));
        }

        private FrontendAuthcConfig getFallbackFrontendConfig() {
            LegacySgConfig sgConfig = this.configRepository.getConfiguration(CType.CONFIG).getCEntry("sg_config");
            if (sgConfig != null && sgConfig.getRestAuthcConfig().getAuthenticators().stream().anyMatch(d -> d.getFrontend() != null && "basic".equalsIgnoreCase(((HttpAuthenticationFrontend)d.getFrontend()).getType()))) {
                return FrontendAuthcConfig.BASIC;
            }
            RestAuthcConfig restAuthcConfig = this.configRepository.getConfiguration(CType.AUTHC).getCEntry("default");
            if (restAuthcConfig != null && restAuthcConfig.getAuthenticators().stream().anyMatch(d -> d.getFrontend() instanceof BasicAuthenticationFrontend)) {
                return FrontendAuthcConfig.BASIC;
            }
            return null;
        }
    }

    public static class Response
    extends Action.Response {
        private List<ActivatedFrontendConfig.AuthMethod> authMethods;
        private FrontendAuthcConfig.LoginPage loginPage;

        public Response() {
        }

        public Response(List<ActivatedFrontendConfig.AuthMethod> authMethods, FrontendAuthcConfig.LoginPage loginPage) {
            this.authMethods = authMethods;
            this.loginPage = loginPage;
        }

        public Response(Action.UnparsedMessage message) throws ConfigValidationException {
            super(message);
            DocNode docNode = message.requiredDocNode();
            this.loginPage = FrontendAuthcConfig.LoginPage.parse(docNode.getAsNode("login_page"), null);
            this.authMethods = docNode.getAsListFromNodes("auth_methods", ActivatedFrontendConfig.AuthMethod::new);
        }

        public Object toBasicObject() {
            return ImmutableMap.of((Object)"auth_methods", this.authMethods, (Object)"login_page", this.loginPage != null ? this.loginPage.toBasicObject() : null);
        }
    }
}

